<?php 
if ( !defined('ABSPATH') )
    exit;

/*
Plugin Name: Dogri Toolkit
Plugin URI: https://themeforest.net/user/gramentheme/portfolio
Description: Dogri Toolkit Plugin
Version: 1.0.1
Author: Gramentheme
Author URI: https://themeforest.net/user/gramentheme/portfolio
*/

define( 'DOGRI_TOOLKIT_VER', '1.0.1' );
define( 'DOGRI_TOOLKIT_DIR', plugin_dir_path( __FILE__ ) );
define( 'DOGRI_TOOLKIT_URL', plugin_dir_url( __FILE__ ) );

define( 'DOGRI_TOOLKIT_METABOX_ACTIVED', in_array( 'cmb2/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) );

final class Dogri_Toolkit {

	private static $instance;

	function __construct() {

		require_once DOGRI_TOOLKIT_DIR . '/inc/dogri-portfolios.php';
		// require_once DOGRI_TOOLKIT_DIR . '/inc/dogri-member-post.php';
    	require_once DOGRI_TOOLKIT_DIR . '/inc/dogri-meta-boxes.php';
    	require_once DOGRI_TOOLKIT_DIR . '/inc/dogri-service-post.php';

    	/**
		* widgets
		*/
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-about-info-widget.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-author-profile-widget.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-latest-posts-sidebar.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-latest-posts-footer.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-subscriber-widget.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-cta-widget.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-cta-widget-2.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-service-categories.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-contact-info-widget.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/social-profiles-widget.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-google-map-widget.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-help-widget.php';
		require_once DOGRI_TOOLKIT_DIR . '/widgets/dogri-download-widget.php';

    	add_filter( 'template_include', array( $this, '_service_template_include' ) );

		add_filter('excerpt_length', array($this,'custom_post_excerpt'));
		add_filter('excerpt_more', array($this,'custom_new_excerpt_more'));
	}

	public static function instance() {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Dogri_Toolkit ) ) {
			self::$instance = new Dogri_Toolkit;
		}
		return self::$instance;
	}

	public function _service_template_include( $template ) {
		if ( is_singular( 'dogri-service' ) ) {
			return $this->_get_service_template( 'single-dogri-service.php');
		}
		return $template;
	}
	
	public function _get_service_template( $template ) {
		if ( $theme_file = locate_template( array( $template ) ) ) {
			$file = $theme_file;
		} else {
			$file = DOGRI_TOOLKIT_DIR . 'template/'. $template;
		}
		return apply_filters( __FUNCTION__, $file, $template );
	}

	
	function custom_post_excerpt($length){
		global $post;
		if ($post->post_type == 'dogri-service')
			return 15;
		return $length;
	}

	function custom_new_excerpt_more( $more ) {
		global $post;
		if ($post->post_type == 'dogri-service')
			return '';
		return $more;
	}
}

function Dogri_Toolkit() {

	return Dogri_Toolkit::instance();
}

Dogri_Toolkit();


/**
* taxonomy category
*/
function dogri_get_terms($id,$tax){
    $terms = get_the_terms( get_the_ID(), $tax ); 
    $list = '';
    if ( $terms && ! is_wp_error( $terms ) ) : 
        $i=1;
        $cats_count = count($terms);
        foreach ( $terms as $term ) {
            $exatra = ( $cats_count > $i ) ? ', ' : '';
            $list .= $term->name . $exatra;
            $i++;
        }
    endif;
    return trim($list,',');
}
