<?php
	/**
	 * Medodove Social Widget
	 *
	 *
	 * @author 		basictheme
	 * @category 	Widgets
	 * @package 	Medodove/Widgets
	 * @version 	1.0.1
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'dogri_subscriber_widget');
	function dogri_subscriber_widget() {
		register_widget('dogri_subscriber_widget');
	}
	
	
	class Dogri_Subscriber_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('dogri_subscriber_widget',esc_html__('Dogri Subscriber','dogri-toolkit'),array(
				'description' => esc_html__('Dogri Subscriber Widget','dogri-toolkit'),
			));
		}
		
		public function widget($args,$instance){
			extract($args);
			extract($instance);
		 	print $before_widget; 
			?>
			<?php 
			if( $subscribe_style === 'style_1'): ?>
				<div class="subscribe-form-area style-1">
					<div class="container">
						<div class="row">
							<div class="col-12">
								<!-- Newsletter Section Start !-->
								<div class="subscribe-area">
									<!-- <div class="shape-bg">
										<img src="<?php echo esc_url(get_template_directory_uri()); ?>/img/shape/subscribe-form-bg.png" alt="shape" />
									</div> -->
								<div class="triangle-shape"></div>
									<div class="subscribe-inner-area">
										<div class="content-wrapper">
											<?php
											if( $sub_title !== "" ): ?>
												<h4 class="short-title"><?php echo wp_kses_post( $sub_title ); ?></h4>
											<?php
											endif; ?>

											<?php
											if( $title !== ""): ?>
												<h2 class="subscribe-title"> <?php echo apply_filters( 'widget_title', $title ); ?></h2>
											<?php
											endif; ?>

											<?php 
											if( $description !== ""): ?>
												<p class="text"><?php echo wp_kses_post( $description ); ?></p>
											<?php
											endif; ?>	
										</div>
										<div class="subscribe-form-wrapper">
											<div class="subscribe-form-widget">
												<?php
												if($mailchimp_shortcode!=''){
													echo do_shortcode($mailchimp_shortcode);
												}
												?>
											</div>
										</div>
									</div>
								</div>
								<!-- Newsletter Section End !-->
							</div>
						</div>
					</div>
				</div>
			<?php 
			elseif( $subscribe_style === 'style_2' ): ?>
				<?php
				if($instance['title']):
					echo $before_title; ?> 
						<?php echo apply_filters( 'widget_title', $instance['title'] ); ?>
					<?php echo $after_title; ?>
				<?php 
				endif; ?>
					<!-- Newsletter Section Start !-->
					<div class="subscribe-form-wrapper">
						<?php 
						if( $description !== ""): ?>
							<p class="text"><?php echo wp_kses_post( $description ); ?></p>
						<?php
						endif; ?>
						<div class="subscribe-form-widget">
							<?php
							if($mailchimp_shortcode!=''){
								echo do_shortcode($mailchimp_shortcode);
							}
							?>
						</div>
					</div>
					<!-- Newsletter Section End !-->
			<?php 
			elseif( $subscribe_style === 'style_3' ): ?>
				<div class="footer-widget-info">
					<?php 
					if( $logo_url ): ?>
					<div class="footer-logo">
						<a href="<?php  print home_url(); ?>"><img src="<?php echo esc_url( $logo_url ); ?>" alt="Footer Logo" /></a>
					</div>
					<?php 
					endif; ?>

					<p><?php echo wp_kses_post( $description ); ?></p>
					<div class="info-form-and-social-icon">
						<!-- Newsletter Section Start !-->
						<div class="subscribe-form-wrapper">
							<div class="subscribe-form-widget">
								<?php
								if($mailchimp_shortcode!=''){
									echo do_shortcode($mailchimp_shortcode);
								}
								?>
							</div>
						</div>
						<!-- Newsletter Section End !-->
						<div class="social-profile">
							<?php 
							if($facebook !== ""): ?>
								<a href="<?php print esc_url($facebook); ?>"><i class="fab fa-facebook-f"></i></a>
							<?php 
							endif; ?>

							<?php 
							if($twitter !== ""): ?>
								<a href="<?php print esc_url($twitter); ?>"><i class="fab fa-twitter"></i></a>
							<?php 
							endif; ?>

							<?php
							if($instagram !== ""): ?>
								<a href="<?php print esc_url($instagram); ?>"><i class="fab fa-instagram"></i></a>
							<?php 
							endif; ?>

							<?php 
							
							if($pinterest !== "" ): ?>
								<a href="<?php print esc_url($pinterest); ?>"><i class="fab fa-pinterest-p"></i></a>
							<?php
							endif; ?>
						</div>
					</div>
				</div>
			<?php
			endif; ?>







	    	<?php print $after_widget; ?>  
		<?php
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){
			$title  = isset($instance['title'])? $instance['title']:'';
			$logo_url  = isset($instance['logo_url'])? $instance['logo_url']:'';
			$sub_title  = isset($instance['sub_title'])? $instance['sub_title']:'';
			$subscribe_style  = isset($instance['subscribe_style'])? $instance['subscribe_style'] : 'style_1';
			$description  = isset($instance['description'])? $instance['description']:'';
			$mailchimp_shortcode  = isset($instance['mailchimp_shortcode'])? $instance['mailchimp_shortcode']:'';

			$facebook  = isset($instance['facebook'])? $instance['facebook']:'';
			$twitter  = isset($instance['twitter'])? $instance['twitter']:'';
			$instagram  = isset($instance['instagram'])? $instance['instagram']:'';
			$pinterest  = isset($instance['pinterest'])? $instance['pinterest']:'';
			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

			<p>
				<label for="sub_title"><?php esc_html_e('Sub Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('sub_title')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('sub_title')); ?>" value="<?php print esc_attr($sub_title); ?>">
			
			<p>
				<label for="logo_url"><?php esc_html_e('Logo Url:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('logo_url')); ?>"  name="<?php print esc_attr($this->get_field_name('logo_url')); ?>" value="<?php print esc_attr($logo_url); ?>">

			<p>
				<label for="<?php echo $this->get_field_id('subscribe_style'); ?>">Choose Style</label>
				<select name="<?php echo $this->get_field_name('subscribe_style'); ?>" id="<?php echo $this->get_field_id('subscribe_style'); ?>" class="widefat">

					<option value="" disabled="disabled">Select Subscribe Style</option>
					<option value="style_1" <?php if($subscribe_style === 'style_1'){ echo 'selected="selected"'; } ?>>Style 1</option>
					<option value="style_2" <?php if($subscribe_style === 'style_2'){ echo 'selected="selected"'; } ?>>Style 2</option>
					<option value="style_3" <?php if($subscribe_style === 'style_3'){ echo 'selected="selected"'; } ?>>Style 3</option>
				</select>
			</p>


			<p>
				<label for="title"><?php esc_html_e('Short Description:','dogri-toolkit'); ?></label>
			</p>

			<textarea class="widefat" rows="7" cols="15" id="<?php print esc_attr($this->get_field_id('description')); ?>" value="<?php print esc_attr($description); ?>" name="<?php print esc_attr($this->get_field_name('description')); ?>"><?php print esc_attr($description); ?></textarea>


			<p>
				<label for="mailchimp_shortcode"><?php esc_html_e('Mailchimp Shortcode:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('mailchimp_shortcode')); ?>" class="widefat" name="<?php print esc_attr($this->get_field_name('mailchimp_shortcode')); ?>" value="<?php print esc_attr($mailchimp_shortcode); ?>">
			
			<p>
				<label for="title"><?php esc_html_e('Facebook:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('facebook')); ?>"  name="<?php print esc_attr($this->get_field_name('facebook')); ?>" value="<?php print esc_attr($facebook); ?>">

			<p>
				<label for="title"><?php esc_html_e('Twitter:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('twitter')); ?>"  name="<?php print esc_attr($this->get_field_name('twitter')); ?>" value="<?php print esc_attr($twitter); ?>">


			<p>
				<label for="instagram"><?php esc_html_e('Instagram:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('instagram')); ?>"  name="<?php print esc_attr($this->get_field_name('instagram')); ?>" value="<?php print esc_attr($instagram); ?>">

			<p>
				<label for="pinterest"><?php esc_html_e('Pinterest:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('pinterest')); ?>"  name="<?php print esc_attr($this->get_field_name('pinterest')); ?>" value="<?php print esc_attr($pinterest); ?>">

			
			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['logo_url'] = ( ! empty( $new_instance['logo_url'] ) ) ? strip_tags( $new_instance['logo_url'] ) : '';
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['sub_title'] = ( ! empty( $new_instance['sub_title'] ) ) ? strip_tags( $new_instance['sub_title'] ) : '';
			$instance['subscribe_style'] = ( ! empty( $new_instance['subscribe_style'] ) ) ? strip_tags( $new_instance['subscribe_style'] ) : '';
			$instance['description'] = ( ! empty( $new_instance['description'] ) ) ? strip_tags( $new_instance['description'] ) : '';

			$instance['mailchimp_shortcode'] = ( ! empty( $new_instance['mailchimp_shortcode'] ) ) ? strip_tags( $new_instance['mailchimp_shortcode'] ) : '';

			$instance['facebook'] = ( ! empty( $new_instance['facebook'] ) ) ? strip_tags( $new_instance['facebook'] ) : '';
			$instance['twitter'] = ( ! empty( $new_instance['twitter'] ) ) ? strip_tags( $new_instance['twitter'] ) : '';
			$instance['instagram'] = ( ! empty( $new_instance['instagram'] ) ) ? strip_tags( $new_instance['instagram'] ) : '';
			$instance['pinterest'] = ( ! empty( $new_instance['pinterest'] ) ) ? strip_tags( $new_instance['pinterest'] ) : '';
			return $instance;
		}
	}