<?php

// theme color
function enqueue_custom_color_stylesheet() {
    // Enqueue the main stylesheet
    wp_enqueue_style('dogri-style', get_stylesheet_uri());

    // Get the custom primary color from the customizer
    $primary_color = get_theme_mod('dogri_theme_color', '#eb753b');
    $primary_color_2 = get_theme_mod('dogri_theme_color_2', '#02afe5');

    // Enqueue the dynamic CSS file with custom color
    wp_enqueue_style('custom-color-theme', get_template_directory_uri() . '/css/color/theme-color.css');
    wp_add_inline_style('custom-color-theme', '
        
	

        .product__details-rating a,
        .woocommerce .star-rating span,
        .team-content span,
        .doctor-card span,
        .doctor-card-2 .doctor-title a:hover,
        .doctor-content span,
        .footer-info-icon span,
        .link-text a:hover,
        .main-menu ul li:hover > a,
        .header-top ul.info-list i,
        .product-tag span,
        .footer-conditions ul li a:hover,
        .footer-link ul li a:hover,
        .blog-title a:hover,
        .link-text-white a:hover,
        .service-content h4 a:hover 

        {
        color: ' . esc_attr($primary_color) . ';
        }



        .post-content-wrapper a.theme-btn,
        .wc-block-components-checkout-place-order-button,
        .summary.entry-summary a.tinvwl_add_to_wishlist_button.tinvwl-icon-heart.no-txt.tinvwl-product-already-on-wishlist.tinvwl-position-after.tinvwl-product-in-list, .product__add-cart .tinv-wraper.tinv-wishlist,
        .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current,
        .doctor-social-3 ul li a:hover,
        .benefit-count,
        .footer-link ul li a::after,
        .features__list ul li::after,
        .main-menu ul li .submenu li:hover > a,
        .header-action-badge,
        .why-choose-icon span,
        .doctor-social a:hover,
        .process-info-number span,
        .section-subtitle-5:after,
        .about-thumb-logo,
        .product-badge > span,
        .solid-btn,
        .discount-slider-navigation button:hover,
        .solid-btn,
        .newsletter-input .fill-btn-1,
        .common-slider-navigation button:hover,
        .header-quick-access::before,
        .header-quick-access,
        .footer-round-btn:hover,
        .theme-social a:hover,
        .round-link:hover,
        .team-social a:hover,
        .common-slider-navigation button:hover,
        .why-choose-icon span,
        .service-item:hover .service-icon span,
        .health-icon span,
        .round-link-40:hover,
        .review-navigation button:hover,
        .footer-style-3 .theme-social a:hover,
        .fill-btn

        {
        background: ' . esc_attr($primary_color) . ';
        }        
          
        
        
        .widget .wp-block-search button,
        .widget .search-form button,
        .basic-pagination .page-numbers:hover,
        .basic-pagination .post-page-numbers:hover,
        .page-links .page-numbers:hover,
        .page-links .post-page-numbers:hover,
        .wp-block-query-pagination-numbers .page-numbers:hover,
        .wp-block-query-pagination-numbers .post-page-numbers:hover,
        .basic-pagination .page-numbers.current,
        .basic-pagination .post-page-numbers.current,
        .page-links .page-numbers.current,
        .page-links .post-page-numbers.current,
        .wp-block-query-pagination-numbers .page-numbers.current,
        .wp-block-query-pagination-numbers .post-page-numbers.current,
        .widget .social-profile a:hover,
        .widget .tagcloud a:hover,
        .news-section .post-info,
        .post-card.style-two .image .icon,
        .author-social-profiles a,
        .widget .wp-block-search button,        
        .widget_promotion .secondary-btn,
        .single-post-item .blog-post-tag .post-tag-list a:hover,
        .latest-comments li .comments-box .comments-text .comment-reply-link:hover {

        background-color: ' . esc_attr($primary_color) . ';

        }

        .single-post-item .post-title:hover a,
        .single-post-item .post-meta span i,
        .blog-post-nav .post-navigation .text span,
        .widget_latest_post ul li .latest-post-desc .latest-post-title a:hover,
        .widget .wp-block-tag-cloud a:hover,
        .widget .wp-block-latest-comments li a:hover,
        .widget .wp-block-latest-posts li a:hover,
        .a.news-btn-1:hover,
        .ul.tags-list-1 li:hover,
        .ul.popular-tag li:hover,
        .news-section .post-info h5:hover > a,
        .single-post-item .social-share a:hover,        
        .single-post-item button.post-gallery-btn:hover,
        .single-post-item button.post-gallery-btn:hover i,
        .single-post-item .post-meta span a:hover,
        .single-post-item .post-meta span a:hover i,
        .author-info .author-post a,
        .post-card.style-one .content .title,
        .post-card.style-two .content .title:hover,
        .post-card.style-four .content .title:hover,
        .post-card.style-three .content .title:hover,
        .post-card.style-four .content .title:hover {

        color: ' . esc_attr($primary_color) . ';

        }



        .contact-from,
        .contact-info-icon span,
        .author-social,
        .doctor-card-2,
        .doctor-social-3,
        .bd__faq .accordion-button:not(.collapsed)::after,
        .benefit-round,
        .advantage-icon > span,
        .what-we-do-icon span,
        .countdown-wrapper ul li,
        .video-play-btn,
        .offcanvas__social ul li a:hover,
        .offcanvas__contact ul li:hover i,
        .offcanvas__close button,
        .bd-faq .accordion-button:not(.collapsed) .accordion-number,
        .section-subtitle span,
        .section-subtitle span::before,
        .footer-round-btn,
        .about-info-wrapper,
        .dogri_wishlist_btn,
        .dogri_quick_view_btn, .dogri_cart_btn,
        .header-search button,
        .appointment-contact-icon span,
        .service-wrapper:after,
        .banner-play,
        .intro-bg,
        .team-card,
        .testimonial-bg,
        .service-bg,
        .section-subtitle-2:after,
        .banner-bg-thumb,
        .blog-badge span,
        .fill-btn::before,
        .bd-progress__skill-item .progress-bar,
        .skill-thumb,
        .round-cercle .image-text,
        .service-icon span,
        .about-info-icon span,
        .theme-bg-1{

        background-color: ' . esc_attr($primary_color_2) . ';

        }


        .doctor-author-info .icon,
        .section-subtitle-6,
        .offcanvas__social ul li a,
        .offcanvas__contact-text a:hover,
        .accordion-number,
        .product-price bdi,
        .section-subtitle-4,
        .text-color-1,
        .appointment-input-title,
        .counter-content h2,
        .blog-content-title a:hover,
        .about-experience h2,
        .section-subtitle-2,
        .bd-progress__skill-item .progress-count {

        color: ' . esc_attr($primary_color_2) . ';

        }


		
    ');
}
add_action('wp_enqueue_scripts', 'enqueue_custom_color_stylesheet');