<?php 
class Portfolio_Post_Widget 
{
	function __construct() {
		add_action( 'init', array( $this, 'register_custom_post_type' ) );
		add_action( 'init', array( $this, 'create_cat' ) );
		add_filter( 'cmb2_meta_boxes', array( $this, 'add_meta' ) );
		add_filter( 'cmb2_meta_boxes', array( $this, 'add_content_meta' ) );
		add_filter( 'template_include', array( $this, 'portfolio_template_include' ) );
	}
	
	public function portfolio_template_include( $template ) {
		if ( is_singular( 'dogri-portfolio' ) ) {
			return $this->get_template( 'single-dogri-portfolio.php');
		}
		return $template;
	}
	
	public function get_template( $template ) {
		if ( $theme_file = locate_template( array( $template ) ) ) {
			$file = $theme_file;
		} else {
			$file = DOGRI_TOOLKIT_DIR . '/template/'. $template;
		}
		return apply_filters( __FUNCTION__, $file, $template );
	}
	
	
	public function register_custom_post_type() {

		$labels = array(
			'name'               => __( 'Portfolios', 'Post Type General Name', 'dogri-toolkit'),
			'singular_name'      => __( 'Portfolio', 'Post Type Singular Name', 'dogri-toolkit'),
			'menu_name'          => __( 'Portfolios', 'dogri-toolkit'),
			'parent_item_colon'  => __( 'Parent Portfolio', 'dogri-toolkit'),
			'all_items'          => __( 'All  Portfolios', 'dogri-toolkit'),
			'view_item'          => __( 'View  Portfolios', 'dogri-toolkit'),
			'add_new_item'       => __( 'Add New  Portfolio', 'dogri-toolkit'),
			'add_new'            => __( 'Add New  Portfolio', 'dogri-toolkit'),
			'edit_item'          => __( 'Edit  Portfolio', 'dogri-toolkit'),
			'update_item'        => __( 'Update  Portfolios', 'dogri-toolkit'),
			'search_items'       => __( 'Search  Portfolios', 'dogri-toolkit'),
			'not_found'          => __( 'Not found', 'dogri-toolkit'),
			'not_found_in_trash' => __( 'Not found in Trash', 'dogri-toolkit'),
		);

		$args   = array(
			'label'               => __( 'Portfolios', 'dogri-toolkit'),
			'description'         => __( 'Create and manage all bdevs portfolio', 'dogri-toolkit'),
			'labels'              => $labels,
			'supports'            => array( 'title','thumbnail', 'editor'),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 14,
			'rewrite'             =>  array( 'slug' => 'portfolios', 'with_front' => false ),
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'post',
			'menu_icon'           => 'dashicons-awards',
		);

		register_post_type( 'dogri-portfolio', $args );
	}
	
	public function create_cat() {

		$name = 'Category';

		$labels = array(
			'name'              => esc_html($name),
			'singular_name'     => esc_html($name),
			'search_items'      => sprintf(esc_html__( 'Search %s:', 'dogri-toolkit' ),$name),
			'all_items'      	=> sprintf(esc_html__( 'All %s:', 'dogri-toolkit' ),$name),
			'parent_item'      	=> sprintf(esc_html__( 'Parent  %s:', 'dogri-toolkit' ),$name),
			'parent_item_colon' => sprintf(esc_html__( 'Parent  %s:', 'dogri-toolkit' ),$name),
			'edit_item'     	=> sprintf(esc_html__( 'Edit  %s:', 'dogri-toolkit' ),$name),
			'update_item'     	=> sprintf(esc_html__( 'Update %s:', 'dogri-toolkit' ),$name),
			'add_new_item'      => sprintf(esc_html__( 'Add New %s:', 'dogri-toolkit' ),$name),
			'new_item_name'     => sprintf(esc_html__( 'New  %s Name:', 'dogri-toolkit' ),$name),
			'menu_name'      	=> esc_html($name),
		);

		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'portfolio-cat' ),
		);

		register_taxonomy('portfolio_categories','dogri-portfolio', $args );
	}



	
	public function add_content_meta(array $dogri) {

		$dogri[] = array(
			'id'           => 'dogri-portfolio-contact-info',
			'title'        => esc_html__( 'Content Info', 'dogri-toolkit' ),
			'object_types' => array( 'dogri-portfolio'),
			'fields'       => array(
				array(
			        'name' => esc_html__('Portfolio Details Image ','dogri-toolkit'),
			        'type' => 'file',
			        'id' => 'portfolio_single_img'
		      	),
				array(
			        'name' => esc_html__('Portfolio Small Image One ','dogri-toolkit'),
			        'type' => 'file',
			        'id' => 'portfolio_small_img_one'
		      	),
				array(
			        'name' => esc_html__('Portfolio Small Image Two ','dogri-toolkit'),
			        'type' => 'file',
			        'id' => 'portfolio_small_img_two'
		      	),
			)
		);
		
		return $dogri;
	}



	
	public function add_meta(array $dogri) {

		$dogri[] = array(
			'id'           => 'dogri-portfolio-portfolio',
			'title'        => esc_html__( 'Portfolio Info', 'dogri-toolkit' ),
			'object_types' => array( 'dogri-portfolio'),
			'fields'       => array(
				array(
					'name' => esc_html__( 'Sub Title', 'dogri-toolkit'),
					'id'   => 'portfolio_service_sub_title',
					'type' => 'text',
				),
				array(
					'name' => esc_html__( 'Service Name Label', 'dogri-toolkit'),
					'id'   => 'portfolio_service_name_label',
					'type' => 'text',
				),
				array(
					'name' => esc_html__( 'Service Name', 'dogri-toolkit'),
					'id'   => 'portfolio_service_name',
					'type' => 'text',
				),
				array(
		          'name' => esc_html__( 'Client Name Label', 'dogri-toolkit'),
		          'id'   => 'portfolio_client_name_label',
		          'type' => 'text',
		        ),
		        array(
		          'name' => esc_html__( 'Client Name', 'dogri-toolkit'),
		          'id'   => 'portfolio_client_name',
		          'type' => 'text',
		        ),
				array(
		          'name' => esc_html__( 'Date Label', 'dogri-toolkit'),
		          'id'   => 'portfolio_date_label',
		          'type' => 'text',
		        ),				
		        array(
		          'name' => esc_html__( 'Duration Time', 'dogri-toolkit'),
		          'id'   => 'portfolio_date_duration',
		          'type' => 'text',
		        ),
				array(
		          'name' => esc_html__( 'Task List Label', 'dogri-toolkit'),
		          'id'   => 'portfolio_task_list_label',
		          'type' => 'text',
		        ),				
		        array(
		          'name' => esc_html__( 'Tasks List', 'dogri-toolkit'),
		          'id'   => 'portfolio_task_list',
		          'type' => 'textarea_small',
		        ),


			)
		);
		
		return $dogri;
	}

}

new Portfolio_Post_Widget();