<?php 
class DogriPriceTablePost 
{
	function __construct() {
		add_action( 'init', array( $this, 'register_custom_post_type' ) );
		add_action( 'init', array( $this, 'create_cat' ) );
		add_filter( 'cmb2_meta_boxes', array( $this, 'add_meta' ) );
	}
	

	
	
	public function register_custom_post_type() {

		$labels = array(
			'name'               => __( 'Price Tables', 'Post Type General Name', 'dogri-toolkit'),
			'singular_name'      => __( 'Price Tables', 'Post Type Singular Name', 'dogri-toolkit'),
			'menu_name'          => __( 'Price Tables', 'dogri-toolkit'),
			'parent_item_colon'  => __( 'Parent Price Table', 'dogri-toolkit'),
			'all_items'          => __( 'All  Price Tables', 'dogri-toolkit'),
			'view_item'          => __( 'View  Price Table', 'dogri-toolkit'),
			'add_new_item'       => __( 'Add New  Price Table', 'dogri-toolkit'),
			'add_new'            => __( 'Add New  Price Table', 'dogri-toolkit'),
			'edit_item'          => __( 'Edit  Price Table', 'dogri-toolkit'),
			'update_item'        => __( 'Update  Price Table', 'dogri-toolkit'),
			'search_items'       => __( 'Search  Price Table', 'dogri-toolkit'),
			'not_found'          => __( 'Not found', 'dogri-toolkit'),
			'not_found_in_trash' => __( 'Not found in Trash', 'dogri-toolkit'),
		);

		$args   = array(
			'label'               => __( 'Price Tables', 'dogri-toolkit'),
			'description'         => __( 'Create and manage all bdevs biography', 'dogri-toolkit'),
			'labels'              => $labels,
			'supports'            => array( 'title','thumbnail', 'editor'),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 14,
			'rewrite'             =>  array( 'slug' => 'price-tables', 'with_front' => false ),
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'post',
			'menu_icon'           => 'dashicons-grid-view',
		);

		register_post_type( 'dogri-pricetables', $args );
	}
	
	public function create_cat() {

		$name = 'Category';

		$labels = array(
			'name'              => esc_html($name),
			'singular_name'     => esc_html($name),
			'search_items'      => sprintf(esc_html__( 'Search %s:', 'dogri-toolkit' ),$name),
			'all_items'      	=> sprintf(esc_html__( 'All %s:', 'dogri-toolkit' ),$name),
			'parent_item'      	=> sprintf(esc_html__( 'Parent  %s:', 'dogri-toolkit' ),$name),
			'parent_item_colon' => sprintf(esc_html__( 'Parent  %s:', 'dogri-toolkit' ),$name),
			'edit_item'     	=> sprintf(esc_html__( 'Edit  %s:', 'dogri-toolkit' ),$name),
			'update_item'     	=> sprintf(esc_html__( 'Update %s:', 'dogri-toolkit' ),$name),
			'add_new_item'      => sprintf(esc_html__( 'Add New %s:', 'dogri-toolkit' ),$name),
			'new_item_name'     => sprintf(esc_html__( 'New  %s Name:', 'dogri-toolkit' ),$name),
			'menu_name'      	=> esc_html($name),
		);

		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'price-table-cat' ),
		);

		register_taxonomy('price_tables_categories','dogri-pricetables', $args );
	}


	public function add_meta(array $dogri) {
		$prefix = 'price_table_';
		$dogri[] = array(
			'id'           => 'dogri-pricetable-sec',
			'title'        => esc_html__( 'Pricing Info Detials', 'dogri-toolkit' ),
			'object_types' => array( 'dogri-pricetables'),
			'fields'       => array(
				array(
			        'name' => esc_html__('Price Small Icon','dogri-toolkit'),
			        'type' => 'file',
			        'id' => $prefix . 'small_icon'
		      	),
				array(
			        'name' => esc_html__('Price Icon Image','dogri-toolkit'),
			        'type' => 'file',
			        'id' => $prefix . 'icon_thumb'
		      	),
		      	array(
			        'name' => esc_html__('Price','dogri-toolkit'),
			        'type' => 'text',
			        'id'   => $prefix . 'price'
		      	),				
		      	array(
			        'name' => esc_html__('Info Text','dogri-toolkit'),
			        'type' => 'textarea',
			        'id'   => $prefix . 'info_text'
		      	),				
		      	array(
			        'name' => esc_html__('Button Url','dogri-toolkit'),
			        'type' => 'text',
			        'id'   => $prefix . 'link_url'
		      	),
			)
		);
		
		return $dogri;
	}

}

new DogriPriceTablePost();