<?php
	/**
	 * Medodove Social Widget
	 *
	 *
	 * @author 		basictheme
	 * @category 	Widgets
	 * @package 	Medodove/Widgets
	 * @version 	1.0.1
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'dogri_help_widget');
	function dogri_help_widget() {
		register_widget('dogri_help_widget');
	}
	
	
	class Dogri_Help_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('dogri_help_widget',esc_html__('Dogri Help Widget','dogri-toolkit'),array(
				'description' => esc_html__('Dogri Help Widget','dogri-toolkit'),
			));
		}
		
		public function widget($args,$instance){
			extract($args);
			extract($instance);
		 	print $before_widget; 
			 if($instance['title']):
                echo $before_title; ?> 
                    <?php echo apply_filters( 'widget_title', $instance['title'] ); ?>
                <?php echo $after_title; ?>
            <?php endif; ?>

		<div class="footer-working-info">
			<span><?php echo $title_0; ?></span>
			<h6><?php echo $sub_title; ?></h6>
		</div>
		<div class="footer-working-info">
			<span><?php echo $title_1; ?></span>
			<h6><?php echo $sub_title_1; ?></h6>
		</div>
		<div class="footer-working-info">
			<span><?php echo $title_2; ?></span>
			<h6><?php echo $sub_title_2; ?></h6>
		</div>


	    	<?php print $after_widget; ?>  
		<?php
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){		
			

			$title  = isset($instance['title'])? $instance['title']:'';
			$title_0  = isset($instance['title_0'])? $instance['title_0']:'';
			$sub_title  = isset($instance['sub_title'])? $instance['sub_title']:'';
			$title_1  = isset($instance['title_1'])? $instance['title_1']:'';
			$sub_title_1  = isset($instance['sub_title_1'])? $instance['sub_title_1']:'';
			$title_2  = isset($instance['title_2'])? $instance['title_2']:'';
			$sub_title_2  = isset($instance['sub_title_2'])? $instance['sub_title_2']:'';
			
			?>                 


			<p>
				<label for="title"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

			<p>
				<label for="title_0"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('title_0')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('title_0')); ?>" value="<?php print esc_attr($title_0); ?>">

			<p>
				<label for="sub_title"><?php esc_html_e('Sub Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('sub_title')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('sub_title')); ?>" value="<?php print esc_attr($sub_title); ?>">  
			

			<p>
				<label for="title_1"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('title_1')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('title_1')); ?>" value="<?php print esc_attr($title_1); ?>">

			<p>
				<label for="sub_title_1"><?php esc_html_e('Sub Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('sub_title_1')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('sub_title_1')); ?>" value="<?php print esc_attr($sub_title_1); ?>">  


			<p>
				<label for="title_2"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('title_2')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('title_2')); ?>" value="<?php print esc_attr($title_2); ?>">

			<p>
				<label for="sub_title_2"><?php esc_html_e('Sub Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('sub_title_2')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('sub_title_2')); ?>" value="<?php print esc_attr($sub_title_2); ?>">  



			
			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['sub_title'] = ( ! empty( $new_instance['sub_title'] ) ) ? strip_tags( $new_instance['sub_title'] ) : '';
			$instance['title_0'] = ( ! empty( $new_instance['title_0'] ) ) ? strip_tags( $new_instance['title_0'] ) : '';
			$instance['sub_title_1'] = ( ! empty( $new_instance['sub_title_1'] ) ) ? strip_tags( $new_instance['sub_title_1'] ) : '';
			$instance['title_1'] = ( ! empty( $new_instance['title_1'] ) ) ? strip_tags( $new_instance['title_1'] ) : '';
			$instance['sub_title_2'] = ( ! empty( $new_instance['sub_title_2'] ) ) ? strip_tags( $new_instance['sub_title_2'] ) : '';
			$instance['title_2'] = ( ! empty( $new_instance['title_2'] ) ) ? strip_tags( $new_instance['title_2'] ) : '';

			
			return $instance;
		}
	}