<?php
/**
 * dogri functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package dogri
 */

if ( ! function_exists( 'dogri_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function dogri_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on dogri, use a find and replace
		 * to change 'dogri' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'dogri', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'main-menu' => esc_html__( 'Main Menu', 'dogri' ),
			'footer-menu' => esc_html__( 'Footer Menu', 'dogri' )
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'dogri_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Enable custom header
		 */
		add_theme_support('custom-header');
	
		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );

		/**
		 * Enable suporrt for Post Formats
		 *
		 * see: https://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array(
			'image',
			'audio',
			'video',
			'gallery',
			'quote',
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );


		// Add support for WooCommerce.
		add_theme_support( 'woocommerce' );

		// Editor style css
		add_editor_style( 'css/theme-editor-style.css' );
		

		add_image_size( 'dogri-portfolio-thumb', 550, 470, array('center','center') );
		add_image_size( 'dogri-service-thumb', 633, 675, array('center','center') );
		add_image_size( 'tc-service-tall-featured', 425, 562, array('center','center') );
		add_image_size( 'dogri-featured-post-full', 872, 604, array('center','center') );
		add_image_size( 'dogri-featured-post-thumb', 405, 328, array('center','center') );
		add_image_size( 'dogri-latest-blog-post-small', 420, 300, array('center','center') );
		add_image_size( 'dogri-latest-blog-post-medium', 635, 480, array('center','center') );
	}
endif;
add_action( 'after_setup_theme', 'dogri_setup' );


/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function dogri_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'dogri_content_width', 640 );
}
add_action( 'after_setup_theme', 'dogri_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function dogri_widgets_init() {

	/**
	* blog sidebar
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Right Sidebar', 'dogri' ),
		'id'            => 'right-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title-box">
                                    <h4 class="widget-title">',
		'after_title'   => '</h4></div>',
	) );

	/**
	* Footer Top Subscribe Widget
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Top Widget : Working Time', 'dogri' ),
		'id'            => 'footer-top-subscribe-widget',
		'description'   => esc_html__( 'Footer Top Working Time', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-top-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="footer-widget-title"> <h4>',
		'after_title'   => '</h4> </div>',
	) );

	/**
	* Footer Widget Style 1 er 1st Widget
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 1 : About Us', 'dogri' ),
		'id'            => 'footer-widget-about-us-widget',
		'description'   => esc_html__( '1st Widget of Footer Widget Style 1', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="footer-widget-title">',
		'after_title'   => '</h2>',
	) );

	/**
	* Footer Widget Style 1 er 1st Widget
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 1 : Links', 'dogri' ),
		'id'            => 'footer-widget-links-widget',
		'description'   => esc_html__( '1st Widget of Footer Widget Style 1', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="footer-widget-title"> <h4>',
		'after_title'   => '</h4> </div>',
	) );

	/**
	* Footer Widget Style 1 er 3rd Widget
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 1 : Help', 'dogri' ),
		'id'            => 'footer-widget-help-widget',
		'description'   => esc_html__( '3rd Widget of Footer Widget Style 1', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="footer-widget-title">',
		'after_title'   => '</h2>',
	) );

	/**
	* Footer Widget Style 1 er 4th Widget
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 1 : Latest Posts', 'dogri' ),
		'id'            => 'footer-widget-latest-posts-widget',
		'description'   => esc_html__( '4th Widget of Footer Widget Style 1', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-widget widget-title %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="footer-widget-title">',
		'after_title'   => '</h4>',
	) );

	/**
	* Footer Widget Style 2 er Top CTA Widget 
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 2 : CTA Top Widget', 'dogri' ),
		'id'            => 'fws-2-er-top-widget',
		'description'   => esc_html__( '1st Widget of Footer Widget Style 2', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-top-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h5 class="footer-widget-title">',
		'after_title'   => '</h5>',
	) );

	/**
	* Footer Widget Style 2 er Top CTA Widget Two
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 2 : CTA Top Widget Two', 'dogri' ),
		'id'            => 'fws-2-er-top-widget2',
		'description'   => esc_html__( '2nd Widget of Footer Widget Style 2', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-top-widget2 %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="footer-widget-title2">',
		'after_title'   => '</h4>',
	) );

	/**
	* Footer Widget Style 2 er 1st Widget 
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 2 : Subscribe Widget', 'dogri' ),
		'id'            => 'fws-2-er-1st-widget',
		'description'   => esc_html__( '1st Widget of Footer Widget Style 2', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="footer-widget-title">',
		'after_title'   => '</h2>',
	) );

	/**
	* Footer Widget Style 2 er 2nd Widget
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 2 : Links', 'dogri' ),
		'id'            => 'fws-2-er-second-widget',
		'description'   => esc_html__( '2nd Widget of Footer Widget Style 2', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="footer-widget-title"> <h4>',
		'after_title'   => '</h4> </div>',
	) );

	/**
	* Footer Widget Style 2 er 3rd Widget
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 2 : Latest Posts', 'dogri' ),
		'id'            => 'fws-2-er-third-widget',
		'description'   => esc_html__( '3rd Widget of Footer Widget Style 2', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="footer-widget-title">',
		'after_title'   => '</h2>',
	) );

	/**
	* Footer Widget Style 2 er 4th Widget
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 1 : Contact Info', 'dogri' ),
		'id'            => 'fws-2-er-fourth-widget',
		'description'   => esc_html__( '4th Widget of Footer Widget Style 2', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="footer-widget-title"> <h4>',
		'after_title'   => '</h4> </div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Style 2 : Contact Info 2', 'dogri' ),
		'id'            => 'fws-2-er-fourth-widget-2',
		'description'   => esc_html__( '4th Widget of Footer Widget Style 2', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="footer-widget-title"> <h4>',
		'after_title'   => '</h4> </div>',
	) );

		/**
	* Footer Widget Style 3 er 8th Widget
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Service Sidebar', 'dogri' ),
		'id'            => 'tc-service-widget',
		'description'   => esc_html__( '8th Widget of Footer Widget Style 3', 'dogri' ),
		'before_widget' => '<div id="%1$s" class="service-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '',
		'after_title'   => '',
	) );


}
add_action( 'widgets_init', 'dogri_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
define('DOGRI_THEME_DIR', get_template_directory() );
define('DOGRI_THEME_URI', get_template_directory_uri());
define('DOGRI_THEME_CSS_DIR', DOGRI_THEME_URI.'/css/');
define('DOGRI_THEME_JS_DIR', DOGRI_THEME_URI.'/js/');
define('DOGRI_THEME_INC', DOGRI_THEME_DIR.'/inc/');

/** 
 * dogri_scripts description
 * @return [type] [description]
 */
function dogri_scripts() {

	// all fonts
	wp_enqueue_style( 'dogri-fonts', dogri_fonts_url(), array(), '1.0.0' );
	wp_enqueue_style( 'google-fonts-1', 'https://fonts.googleapis.com/css2?family=Sora:wght@300;400;500;600;700&display=swap' , array() );
	// all css 
	wp_enqueue_style( 'bootstrap', DOGRI_THEME_CSS_DIR.'bootstrap.min.css', array() );
	wp_enqueue_style( 'animate', DOGRI_THEME_CSS_DIR.'animate.css', array() );
	wp_enqueue_style( 'fontawesome-pro', DOGRI_THEME_CSS_DIR.'fontawesome-pro.css', array() );
	wp_enqueue_style( 'magnific-popup', DOGRI_THEME_CSS_DIR.'magnific-popup.css', array() );
	wp_enqueue_style( 'meanmenu', DOGRI_THEME_CSS_DIR.'meanmenu.min.css', array() );
	wp_enqueue_style( 'slick', DOGRI_THEME_CSS_DIR.'slick.css', array() );
	wp_enqueue_style( 'spacing', DOGRI_THEME_CSS_DIR.'spacing.css', array() );
	wp_enqueue_style( 'swiper.min', DOGRI_THEME_CSS_DIR.'swiper.min.css', array() );
	

	wp_enqueue_style( 'dogri-main', DOGRI_THEME_CSS_DIR.'main.css', array(), '1.0.0' );
	wp_enqueue_style( 'wp-fix', DOGRI_THEME_CSS_DIR.'wp-fix.css', array() );
	wp_enqueue_style( 'dogri-style', get_stylesheet_uri() );



	// all js
	wp_enqueue_script( 'bootstrap-js', DOGRI_THEME_JS_DIR.'bootstrap.bundle.min.js', array('jquery'), '', true );
	// wp_enqueue_script( 'ajax-form-js', DOGRI_THEME_JS_DIR.'ajax-form.js', array('jquery'), false, true );
	wp_enqueue_script( 'beforeafter-js', DOGRI_THEME_JS_DIR.'beforeafter.jquery-1.0.0.min.js', array('jquery'), false, true );
	wp_enqueue_script( 'counterup-js', DOGRI_THEME_JS_DIR.'counterup.js', array('jquery'), false, true );
	wp_enqueue_script( 'jquery-appear-js', DOGRI_THEME_JS_DIR.'jquery.appear.js', array('jquery'), false, true );
	wp_enqueue_script( 'magnific-popup-js', DOGRI_THEME_JS_DIR.'magnific-popup.min.js', array('jquery'), false, true );
	wp_enqueue_script( 'meanmenu-js', DOGRI_THEME_JS_DIR.'meanmenu.min.js', array('jquery'), false, true );
	wp_enqueue_script( 'slick-js', DOGRI_THEME_JS_DIR.'slick.min.js', array('jquery'), false, true );
	wp_enqueue_script( 'swiper-js', DOGRI_THEME_JS_DIR.'swiper.min.js', array('jquery'), false, true );
	wp_enqueue_script( 'waypoints-js', DOGRI_THEME_JS_DIR.'waypoints.min.js', array('jquery'), false, true );
	wp_enqueue_script( 'wow-js', DOGRI_THEME_JS_DIR.'wow.js', array('jquery'), false, true );

	wp_enqueue_script( 'dogri-main', DOGRI_THEME_JS_DIR.'main.js', array('jquery'), '1.0.0', true );
	

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'dogri_scripts' );

/*
Register Fonts
*/
function dogri_fonts_url() {
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'dogri' ) ) {
		$font_url = add_query_arg( 'family', urlencode( 'Poppins:400,500,600,700|Roboto:400,500,700' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}


/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Custom template helper function for this theme.
 */
require get_template_directory() . '/inc/template-helper.php';


/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
* include dogri functions file
*/
require_once DOGRI_THEME_INC . 'dogri_navwalker.php';
require_once DOGRI_THEME_INC . 'dogri_customizer.php';
require_once DOGRI_THEME_INC . 'dogri_customizer_data.php';
require_once DOGRI_THEME_INC . 'class-tgm-plugin-activation.php';
require_once DOGRI_THEME_INC . 'dogri_add_plugin.php';

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function dogri_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'dogri_pingback_header' );

/**
*
* comment section
*
*/
add_filter('comment_form_default_fields', 'dogri_comment_form_default_fields_func');

function dogri_comment_form_default_fields_func($default){
	$default['author'] = '<div class="row">
                            <div class="col-xl-6">
                            	<div class="contacts-name">
                            		<label>'.esc_html__('Your name *','dogri').'</label>
                                	<input type="text" name="author">
                                </div>
                            </div>';
	$default['email'] = '<div class="col-xl-6">
							<div class="contacts-email ">
							<label>'.esc_html__('Your email *','dogri').'</label>
                            <input type="text" name="email">
                        	</div>
                        </div>';
	$default['url'] = '';

	$default['clients_commnet'] = '<div class="col-xl-12">
									<div class="contacts-message">
									<label>'.esc_html__('Comments *','dogri').'</label>
                                     <textarea id="comment" name="comment" cols="30" rows="10"></textarea>
                                    </div>';
	return $default;
}

add_filter('comment_form_defaults', 'dogri_comment_form_defaults_func');

function dogri_comment_form_defaults_func($info){
	if( !is_user_logged_in() ){
		$info['comment_field'] = '';
		$info['submit_field'] = '%1$s %2$s</div></div>';
	}else {
		$info['comment_field'] = '<div class="comments-textarea contacts-message contact-icon">
											<label>'.esc_html__('Comments *','dogri').'</label>
                                                <textarea id="comment" name="comment" cols="30" rows="10"></textarea>';
        $info['submit_field'] = '%1$s %2$s</div>';
	}
	
	$info['submit_button'] = '<button class="fill-btn" type="submit"><span class="fill-btn-inner"><span class="fill-btn-normal">'.esc_html__('Post Comment','dogri').'</span><span class="fill-btn-hover">'.esc_html__('Post Comment','dogri').'</span></span></button>';

	$info['title_reply_before'] = '<div class="post-comments-title">
                                        <h2>';
	$info['title_reply_after'] = '</h2></div>';
	$info['comment_notes_before'] = '';

	

	return $info;
}

if( !function_exists('dogri_comment') ) {
	function dogri_comment($comment, $args, $depth) {
		$GLOBAL['comment'] = $comment;
		extract($args, EXTR_SKIP);
		$args['reply_text'] = '<i class="fas fa-reply-all"></i> Reply';
		$replayClass = 'comment-depth-' . esc_attr($depth);
		?>
			<li id="comment-<?php comment_ID(); ?>" <?php comment_class($replayClass); ?>>
				<div class="postbox__comment mb-60">
					<div class="postbox__comment-box d-sm-flex align-items-start">
						<div class="postbox__comment-info">
							<div class="postbox__comment-avatar">
								<?php print get_avatar($comment, 102, null, null, array('class'=> array())); ?>
							</div>
						</div>
						<div class="postbox__comment-text ">
							<div class="postbox__comment-name">
								<span class="post-meta"><?php comment_time( get_option('date_format') ); ?></span>
								<h5><?php print get_comment_author_link(); ?></h5>
							</div>
							<p><?php comment_text(); ?></p>							
							<div class="postbox__comment-reply">
								<?php comment_reply_link( array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth'] ))); ?>
							</div>
						</div>
					</div>					
				</div>
			</li>	
		<?php
	}
}

/**
* shortcode supports for removing extra p, spance etc
*
*/
add_filter( 'the_content', 'dogri_shortcode_extra_content_remove' );
/**
 * Filters the content to remove any extra paragraph or break tags
 * caused by shortcodes.
 *
 * @since 1.0.0
 *
 * @param string $content  String of HTML content.
 * @return string $content Amended string of HTML content.
 */
function dogri_shortcode_extra_content_remove( $content ) {

    $array = array(
        '<p>['    => '[',
        ']</p>'   => ']',
        ']<br />' => ']'
    );
    return strtr( $content, $array );

}


/**
 * [ocdi_after_import_setup description]
 * @return [type] [description]
 */
function ocdi_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'main-menu' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'ocdi_after_import_setup' );

// dogri_search_filter_form
if(!function_exists('dogri_search_filter_form')){
  function dogri_search_filter_form( $form ) {
    
    $form = sprintf( 
    	'<div class="sidebar-form"><form class="search-form" action="%s" method="get">
      	<input type="text" value="%s" required name="s" placeholder="%s">
      	<button type="submit"> <i class="fas fa-search"></i>  </button>
		</form></div>',
		esc_url( home_url('/')),
		esc_attr( get_search_query()),
		esc_html__('Search','dogri')
	);

    return $form;
  }
  add_filter( 'get_search_form','dogri_search_filter_form');
}

function _html_markup_render( $markup ){
	return $markup;
}

add_action('admin_enqueue_scripts', 'dogri_admin_custom_scripts');
function dogri_admin_custom_scripts(){
	wp_enqueue_media();
	wp_register_script('dogri-admin-custom', get_template_directory_uri().'/inc/js/admin_custom.js', array('jquery'), '', true);
	wp_enqueue_script('dogri-admin-custom');
}



// rtl Function

function enqueue_rtl_styles() {
    $enable_rtl = get_theme_mod('dogri_enable_rtl');

    if ($enable_rtl) {
        wp_enqueue_style('dogri-rtl-css', get_template_directory_uri() . '/css/rtl.css');
    }
}
add_action('wp_enqueue_scripts', 'enqueue_rtl_styles');

function add_rtl_body_class($classes) {
    $enable_rtl = get_theme_mod('dogri_enable_rtl');

    if ($enable_rtl) {
        $classes[] = 'rtl-enabled'; // Add a class when RTL is enabled
    }

    return $classes;
}
add_filter('body_class', 'add_rtl_body_class');


// theme-color
require get_template_directory() . '/inc/theme-color.php';
// demo import
require get_template_directory() . '/inc/demo-import.php';
// woocommerce file import
require get_template_directory() . '/inc/woocommerce.php';




// add action 
add_action('woocommerce_shop_loop_item_title', 'dogri_wc_loop_product_title', 10);
add_action('woocommerce_before_shop_loop_item_title', 'dogri_wc_loop_product_thumbnail', 10);
add_action('woocommerce_after_shop_loop_item_title', 'dogri_wc_loop_rating_loop_price', 10);






// remove actions
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);



// Add filter
add_filter( 'woocommerce_show_page_title' , 'dogri_wc_show_page_title' );






  