<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Contact_Box extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'contact_box';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Contact Box', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'contact_box',
			[
				'label' => esc_html__( 'Contact Box', 'dogri-elementor' ),
			]
		);	
		

		$this->end_controls_section();
		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'seperator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[
															
								'block_icons' =>
								[
									'name' => 'block_icons',
									'label' => esc_html__('Enter The icons', 'theme-elementor'),
									'type' => Controls_Manager::ICONS,							
								],								

								 'block_title' =>
								[
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								 'block_subtitle' =>
								 [
									 'name' => 'block_subtitle',
									 'label' => esc_html__('Sub Title', 'dogri-elementor'),
									 'type' => Controls_Manager::TEXTAREA,
									 'default' => esc_html__('', 'dogri-elementor')
								 ],	
								 
								 'block_btnlink' =>
								[
									'name' => 'block_btnlink',
									'label' => __( 'Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								 'block_subtitle1' =>
								 [
									 'name' => 'block_subtitle1',
									 'label' => esc_html__('Sub Title', 'dogri-elementor'),
									 'type' => Controls_Manager::TEXTAREA,
									 'default' => esc_html__('', 'dogri-elementor')
								 ],	

								 'block_btnlink1' =>
								[
									'name' => 'block_btnlink1',
									'label' => __( 'Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	



		// Section Title 	==================
		
		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);		
		
		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .contact-info-content h4' => 'display: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .contact-info-content h4' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .contact-info-content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .contact-info-content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .contact-info-content h4',
			)
		);
		
		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .contact-info-content h4' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();					
		//End of  Title 	==================	


		//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
	
		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .contact-info-content p' => 'display: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'section_subtitle_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .contact-info-content p' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .contact-info-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .contact-info-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
		
			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .contact-info-content p',
			)
		);
		
		
		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .contact-info-content p' => 'color: {{VALUE}} !important',
				),
			
			)
		);

		$this->add_control(
			'section_subtitle_bg_color',
			array(
				'label'     => __( 'Background Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .contact-info-content p' => 'background-color: {{VALUE}} !important',
				),
			
			)
		);

		$this->end_controls_section();		
		//End of  Sub Title 	==================	


				//========== icon Settings===================================
				
				$this->start_controls_section(
					'icon_control',
					array(
						'label' => __( 'Icon Settings', 'dogri-elementor' ),
						'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
					)
				);
				
				$this->add_control(
					'show_icon',
					array(
						'label' => esc_html__( 'Show Icon', 'dogri-elementor' ),
						'type' => \Elementor\Controls_Manager::CHOOSE,
						'options' => [
							'show' => [
								'show' => esc_html__( 'Show', 'dogri-elementor' ),	
								'icon' => 'eicon-check-circle',
							],
							'none' => [
								'none' => esc_html__( 'Hide', 'dogri-elementor' ),
								'icon' => 'eicon-close-circle',
							],
						],
						'default' => 'show',
						'selectors' => array(
							'{{WRAPPER}} .contact-info-icon span' => 'display: {{VALUE}} !important',
						),
					)
				);
				
				$this->add_control(
					'icon_alingment',
					array(
						'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
						'type' => \Elementor\Controls_Manager::CHOOSE,
						'condition'    => array( 'show_icon' => 'show' ),
						'options' => [
							'left' => [
								'title' => esc_html__( 'Left', 'dogri-elementor' ),
								'icon' => 'eicon-text-align-left',
							],
							'center' => [
								'title' => esc_html__( 'Center', 'dogri-elementor' ),
								'icon' => 'eicon-text-align-center',
							],
							'right' => [
								'title' => esc_html__( 'Right', 'dogri-elementor' ),
								'icon' => 'eicon-text-align-right',
							],
						],
						'default' => '',
						'toggle' => true,
						'selectors' => array(
							'{{WRAPPER}} .contact-info-icon span' => 'text-align: {{VALUE}} !important',
						),
					)
				);	
				
				$this->add_control(
					'icon_color',
					array(
						'label'     => __( ' Color', 'dogri-elementor' ),
						'condition'    => array( 'show_icon' => 'show' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => array(
							'{{WRAPPER}} .contact-info-icon span' => 'color: {{VALUE}} !important',

						),
					)
				);
				
				$this->add_control(
					'icon_bgcolor',
					array(
						'label'     => __( 'Background Color', 'dogri-elementor' ),
						'condition'    => array( 'show_icon' => 'show' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => array(
							'{{WRAPPER}} .contact-info-icon span' => 'background: {{VALUE}} !important',

						),
					)
				);
				
				
				$this->add_control(
					'icon_hover_color',
					array(
						'label'     => __( ' Hover Color', 'dogri-elementor' ),
						'condition'    => array( 'show_icon' => 'show' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => array(
							'{{WRAPPER}} .contact-info-icon span:hover' => 'color: {{VALUE}} !important',

						),
					)
				);
				
				$this->add_control(
					'icon_hover_bgcolor',
					array(
						'label'     => __( 'Background Hover Color', 'dogri-elementor' ),
						'condition'    => array( 'show_icon' => 'show' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => array(
							'{{WRAPPER}} .contact-info-icon span:hover' => 'background: {{VALUE}} !important',

						),
					)
				);
				
				$this->add_control(
					'icon_padding',
					array(
						'label'     => __( 'Padding', 'dogri-elementor' ),
						'type'      => \Elementor\Controls_Manager::DIMENSIONS,
						'condition'    => array( 'show_icon' => 'show' ),
						'size_units' =>  ['px', '%', 'em' ],
					
						'selectors' => array(
							'{{WRAPPER}} .contact-info-icon span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
						),
					)
				);

				$this->add_control(
					'icon_margin',
					array(
						'label'     => __( 'Margin', 'dogri-elementor' ),
						'type'      => \Elementor\Controls_Manager::DIMENSIONS,
						'condition'    => array( 'show_icon' => 'show' ),
						'size_units' =>  ['px', '%', 'em' ],
						'selectors' => array(
							'{{WRAPPER}} .contact-info-icon span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
						),
					)
				);

				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					array(
						'name'     => 'icon_typography',
						'condition'    => array( 'show_icon' => 'show' ),
						'label'    => __( 'Typography', 'dogri-elementor' ),
						'selector' => '{{WRAPPER}} .contact-info-icon span',
					)
				);
				
				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					array(
						'name' => 'icon_border',
						'condition'    => array( 'show_icon' => 'show' ),
						'selector' => '{{WRAPPER}} .contact-info-icon span',
					)
				);
				
				$this->add_control(
					'icon_border_radius',
					array(
						'label'     => __( 'Icon Border Radius', 'dogri-elementor' ),
						'type'      => \Elementor\Controls_Manager::DIMENSIONS,
						'condition'    => array( 'show_icon' => 'show' ),
						'size_units' =>  ['px', '%', 'em' ],
					
						'selectors' => array(
							'{{WRAPPER}} .contact-info-icon span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
						),
					)
				);


				$this->end_controls_section();		
				
				//End of icon


	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 


//write code above the line 

  });
</script>';


?>

<!-- Contact area start -->
<div class="contact-area">
	<div class="container">
	<div class="row g-5">
		<?php foreach($settings['repeat'] as $item):?>
		<div class="col-xxl-4 col-xl-4 col-lg-6">
			<div class="contact-info-item text-center">
				<div class="contact-info-icon">
				<span><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons']['value']));?>"></i></span>
				</div>
				<div class="contact-info-content">
				<h4><?php echo wp_kses($item['block_title'], $allowed_tags);?></h4>
				<p><a href="<?php echo esc_url($item['block_btnlink']['url']);?>"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></a></p>
				<p><a href="<?php echo esc_url($item['block_btnlink1']['url']);?>"><?php echo wp_kses($item['block_subtitle1'], $allowed_tags);?></a></p>
				</div>
			</div>
		</div>
		<?php endforeach; ?>
	</div>         
	</div>
</div>
<!-- Contact area end -->



             
		<?php 
	}


}