<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Counter_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'counter_widget';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Counter Widget', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'counter_widget',
			[
				'label' => esc_html__( 'Counter Widget', 'dogri-elementor' ),
			]
		);		
		
		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Select Style', 'dogri-elementor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => array(
					'style1'   => esc_html__( 'Style One', 'dogri-elementor' ),
					'style2'   => esc_html__( 'Style Two', 'dogri-elementor' ),
					'style3'   => esc_html__( 'Style Three', 'dogri-elementor' ),
				),
			]
		);


		$this->end_controls_section();
		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[													

								 'block_title' =>
								 [
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],
								
								'block_subtitle' =>
								
								[
									'name' => 'block_subtitle',
									'label' => esc_html__('Subtitle', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],	

								'block_subtitle1' =>
								
								[
									'name' => 'block_subtitle1',
									'label' => esc_html__('Subtitle', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],	

								'block_text' =>
								[
									'name' => 'block_text',
									'label' => esc_html__('Text', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],
								
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	

		// Section Title 	==================
		
		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);		
		
		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .counter-content h2' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .benefit-content h3' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .counter-content-2 h2, .counter-content-2 span' => 'display: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .counter-content h2' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .benefit-content h3' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .counter-content-2 h2, .counter-content-2 span' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .counter-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .benefit-content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .counter-content-2 h2, .counter-content-2 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .counter-content h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .benefit-content h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .counter-content-2 h2, .counter-content-2 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .counter-content h2',
				'selector' => '{{WRAPPER}} .benefit-content h3',
				'selector' => '{{WRAPPER}} .counter-content-2 h2, .counter-content-2 span',
			)
		);
		
		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .counter-content h2' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .benefit-content h3' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .counter-content-2 h2, .counter-content-2 span' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();					
		//End of  Title 	==================	

		//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
	
		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .counter-content h5' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .benefit-content p' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .counter-content-2 > p' => 'display: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'section_subtitle_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .counter-content h5' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .benefit-content p' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .counter-content-2 > p' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .counter-content h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .benefit-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .counter-content-2 > p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .counter-content h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .benefit-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .counter-content-2 > p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
		
			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .counter-content h5',
				'selector' => '{{WRAPPER}} .benefit-content p',
				'selector' => '{{WRAPPER}} .counter-content-2 > p',
			)
		);
		
		
		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .counter-content h5' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .benefit-content p' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .counter-content-2 > p' => 'color: {{VALUE}} !important',
				),
			
			)
		);

		$this->add_control(
			'section_subtitle_bg_color',
			array(
				'label'     => __( 'Background Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .counter-content h5' => 'background-color: {{VALUE}} !important',
					'{{WRAPPER}} .benefit-content p' => 'background-color: {{VALUE}} !important',
					'{{WRAPPER}} .counter-content-2 > p' => 'background-color: {{VALUE}} !important',
				),
			
			)
		);

		$this->end_controls_section();		
		//End of  Sub Title 	==================	


		//Background Color ==========================

		$this->start_controls_section(
			'bg_color_block_settings',
			array(
				'label' => __( 'Background Color Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);			
	
		$this->add_control(
			'block_bg_color',
			array(
				'label'     => __( 'Section Background Color', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .counter-area' => 'background-color: {{VALUE}} !important',
				),
			)
		);
	
	
		$this->end_controls_section();
	
		//End of Background Color  


		//Section Padding Block==========================
        $this->start_controls_section(
            'section_padding_settings',
            array(
                'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
        
        $this->add_control(
            'block_margin',
            array(
                'label'     => __( 'Block Margin', 'dogri-elementor' ),
                'type'      => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' =>  ['px', '%', 'em' ],
            
                'selectors' => array(
                    '{{WRAPPER}} .counter-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ),
				'responsive' => true, // This enables responsive settings
            )
        );

        $this->add_control(
            'block_padding',
            array(
                'label'     => __( 'Block Padding', 'dogri-elementor' ),
                'type'      => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' =>  ['px', '%', 'em' ],
            
                'selectors' => array(
                    '{{WRAPPER}} .counter-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ),
				'responsive' => true, // This enables responsive settings
            )
        );

        $this->end_controls_section();
        //End of Section Padding Block 

	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 


//write code above the line 

  });
</script>';


?>

<?php  if ( 'style1' === $settings['style'] ) : ?>
     <!-- Counter area start -->
	 <section class="counter-area section-space-bottom">
         <div class="container">
            <div class="counter-wrapper">
               <div class="row gy-50">
			   <?php foreach($settings['repeat'] as $item):?>
                  <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6">
                     <div class="counter-item">
                        <div class="counter-content">
                           <h2><span class="counter"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>%</h2>
                           <h5><?php echo wp_kses($item['block_title'], $allowed_tags);?></h5>
                        </div>
                     </div>
                  </div>
				  <?php endforeach; ?>
               </div>
            </div>
         </div>
      </section>
      <!-- Counter area end -->

	  <?php  elseif ( 'style2' === $settings['style'] ) : ?>

    <!-- Benefit area star -->
	<div class="benefit-area theme-bg-2 pt-80 pb-80">
         <div class="container">
            <div class="row g-5 justify-content-center">
			<?php foreach($settings['repeat'] as $item):?>
               <div class="col-xxl-3 cl-xl-3 col-lg-3 col-md-6">
                  <div class="benefit-item text-center">
                     <div class="benefit-round">
                        <h3><span class="counter"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>%</h3>
                        <span class="benefit-count"><?php echo wp_kses($item['block_subtitle1'], $allowed_tags);?></span>
                     </div>
                     <div class="benefit-content">
                        <h3><?php echo wp_kses($item['block_title'], $allowed_tags);?></h3>
                        <p> <?php echo wp_kses($item['block_text'], $allowed_tags);?></p>
                     </div>
                  </div>
               </div>
			   <?php endforeach; ?>
            </div>
         </div>
      </div>
      <!-- Benefit area end -->

	  <?php  elseif ( 'style3' === $settings['style'] ) : ?>

		   <!-- Counter area start -->
		   <section class="counter-area theme-bg-1 pt-65 pb-65">
         <div class="container">
            <div class="row gy-5">
				<?php foreach($settings['repeat'] as $item):?>
               <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6">
                  <div class="counter-item-2 text-center">
                     <div class="counter-content-2">
                        <h2 class="counter"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></h2><span>%</span>
                        <p><?php echo wp_kses($item['block_title'], $allowed_tags);?></p>
                     </div>
                  </div>
               </div>
			   <?php endforeach; ?>
            </div>
         </div>
      </section>
      <!-- Counter area end -->

	<?php endif ;?>	
             
		<?php 
	}


}