<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

class Shop_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'shop_widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Product Offer', 'dogri-elementor');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-tabs';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 2.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['dogri-elementor'];
    }

      /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function register_controls()
    {

		$this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Product Settings', 'dogri-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Select Style', 'theme-elementor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => array(
					'style1'   => esc_html__( 'Style One', 'theme-elementor' ),
					'style2'   => esc_html__( 'Style Two', 'theme-elementor' ),
				),
			]
		);
        
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'theme-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your sub title', 'theme-elementor' ),
			]
		);
	
		$this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'theme-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter your title', 'theme-elementor' ),
				]
			);

			
			$this->add_control(
				'bttn',
				[
					'label'       => __( 'Button', 'theme-elementor' ),
					'type'        => Controls_Manager::TEXT,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => esc_html__( 'Enter your Button Title', 'theme-elementor' ),
					'default' => esc_html__('Read More', 'theme-elementor'),
				]
			);	

		$this->add_control(
				'btnlink',
				[
				'label' => __( 'Button Url', 'theme-elementor' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'theme-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				
			]
			);

			$this->add_control(
				'bgimg',
				[
					'label' => esc_html__('Background image', 'theme-elementor'),
					'type' => Controls_Manager::MEDIA,
					'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
			);	

        
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'dogri-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'dogri-elementor'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => $this->get_product_categories(),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'dogri-elementor'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'dogri-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'dogri-elementor'),
                'DESC' => esc_html__('Descending', 'dogri-elementor'),
            ),
            'default' => 'DESC',
            'description' => esc_html__('select order', 'dogri-elementor')
        ]);

		// $this->add_control('tags', [
		// 	'label' => esc_html__('Tags', 'dogri-elementor'),
		// 	'type' => Controls_Manager::SELECT2,
		// 	'multiple' => true,
		// 	'options' => $this->get_product_tags(),
		// 	'description' => esc_html__('Select tags as you want, leave it blank for all tags', 'dogri-elementor'),
		// ]);


        $this->end_controls_section();


    }

	// new
	protected function get_product_categories() {
		$categories = get_terms(array('taxonomy' => 'product_cat', 'hide_empty' => false));
	
		$options = [];
		foreach ($categories as $category) {
			$options[$category->term_id] = $category->name;
		}
	
		return $options;
	}


	protected function get_product_tags() {
		$tags = get_terms(array('taxonomy' => 'product_tag', 'hide_empty' => false));
	
		$options = [];
		foreach ($tags as $tag) {
			$options[$tag->term_id] = $tag->name;
		}
	
		return $options;
	}

/*

<?php
$categories = get_the_terms(get_the_ID(), 'product_cat');
if ($categories && !is_wp_error($categories)) {
	echo '<ul>';
	foreach ($categories as $category) {
		echo '<li><a href="' . get_term_link($category) . '">' . $category->name . '</a></li>';
	}
	echo '</ul>';
}
?>

<?php
global $woocommerce, $product;
$average = $product->get_average_rating();

echo '<div class="star mt-20 star-rating">
	<span style="width:'.( ( $average / 5 ) * 100 ) . '%"><strong itemprop="ratingValue" class="rating">'.$average.'</strong> '.__( 'out of 5', 'woocommerce' ).'
	</span>
</div>';
?>

*/

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */

	protected function render()
    {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];

        $args = array(
            'post_type' => 'product',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'post_status' => 'publish'
        );
        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'product_cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }

        $post_data = new \WP_Query($args);

        ?>

		<?php
			echo '
			<script>
		jQuery(document).ready(function($) {

		//write js code under this line 

		var product = new Swiper(".product-active", {
			slidesPerView: 4,
			spaceBetween: 15,
			loop: true,
			roundLengths: true,
			autoplay: {
				delay: 3000,
			},
			pagination: {
				el: ".bd-swiper-dot",
				clickable: true,
			},
			breakpoints: {
				"1200": {
					slidesPerView: 4,
				},
				"992": {
					slidesPerView: 3,
				},
				"768": {
					slidesPerView: 3,
				},
				"576": {
					slidesPerView: 2,
				},
				"0": {
					slidesPerView: 1,
				},
			},
		});

		//write code above the line 

		});
		</script>';


		?>

<?php  if ( 'style1' === $settings['style'] ) : ?>
    <!-- Latest product area start -->
	<div class="section latest-product-area section-space">
         <div class="container">
            <div class="row">
               <div class="col-xxl6">
                  <div class="row gy-5 align-items-end mb-40">
                     <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                        <div class="section-title-wrapper-4">
                           <span class="section-subtitle-4 mb-10"><?php echo $settings['subtitle'];?></span>
                           <h2 class="section-title-4"><?php echo $settings['title'];?></h2>
                        </div>
                     </div>
                     <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                        <div class="seller-link text-md-end">
                           <a class="solid-btn" href="<?php echo esc_url($settings['btnlink']['url']);?>"><?php echo $settings['bttn'];?><span><i
                                    class="fa-regular fa-angle-right"></i></span></a>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="row">
               <div class="col-xxl-12">
                  <div class="swiper product-active">
                     <div class="swiper-wrapper">
					 <?php while ($post_data->have_posts()) : $post_data->the_post(); ?>
						<?php 
							global $product,$post;
							$product_single_meta_data = get_post_meta(get_the_ID(), 'vaptek_product_options', true);
						?>
                        <div class="swiper-slide">
                           <div class="product-item">
                              <div class="product-badge">
								<?php
									global $product;
									if ($product->is_on_sale()) {
										echo '<span product-trending="sale-tag">10% off</span>';
									}
									?>
                              </div>
                              <div class="product-thumb">
							  <a href="<?php echo get_the_permalink(); ?>" class="product__image pt-20 d-block">
									<?php echo get_the_post_thumbnail( null, 'vaptek-product-thumbnail-1', array('class'=> 'font-image') ) ?>
								</a>
                              </div>
							  <div class="product-action-item">
								<button type="submit" class="dogri_cart_btn">
									<?php woocommerce_template_loop_add_to_cart(); ?>
								</button> 
								 <button type="submit" class="dogri_quick_view_btn">
								 	<?php $product_id = get_the_id();
            						echo do_shortcode("[woosq id='{$product_id}']");?>
								</button>
								<?php if (shortcode_exists('ti_wishlists_addtowishlist')) : ?>
								<button type="submit" class="dogri_wishlist_btn">
									<?php echo do_shortcode('[ti_wishlists_addtowishlist]');?>
								</button>
								<?php endif ?>
                              </div>
                              <div class="product-content">
                                 <div class="product-tag">
									<?php
									$tags = get_the_terms(get_the_ID(), 'product_tag');
									if ($tags && !is_wp_error($tags)) {
										foreach ($tags as $tag) {
											echo '<span><a href="' . get_term_link($tag) . '">' . $tag->name . '</a></span>';
										}									
									}
									?>
                                 </div>
                                 <h4 class="product-title"><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                                 <div class="product-price">
								 	<?php echo $product->get_price_html(); ?>
                                 </div>
                              </div>
                           </div>
                        </div>
						<?php endwhile; ?>
                     </div>
                     <div class="why-choose-pagination text-center">
                        <div class="bd-swiper-dot"></div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- Latest product area end -->

	  <?php  elseif ( 'style2' === $settings['style'] ) : ?>

 	<!-- Best seller area start -->
 	<section class="best-seller-area section-space">
         <div class="container">
            <div class="row gy-50">
               <div class="col-xxl-6 col-xl-6 col-lg-6">
                  <div class="row g-15">
				  <?php while ($post_data->have_posts()) : $post_data->the_post(); ?>
						<?php 
							global $product,$post;
							$product_single_meta_data = get_post_meta(get_the_ID(), 'vaptek_product_options', true);
						?>
                     <div class="col-xxl-6 col-xl-6 col-md-6 col-sm-6">
					 <div class="product-item">
                              <div class="product-badge">
								<?php
									global $product;
									if ($product->is_on_sale()) {
										echo '<span product-trending="sale-tag">10% off</span>';
									}
									?>
                              </div>
                              <div class="product-thumb">
							  <a href="<?php echo get_the_permalink(); ?>" class="product__image pt-20 d-block">
									<?php echo get_the_post_thumbnail( null, 'vaptek-product-thumbnail-1', array('class'=> 'font-image') ) ?>
								</a>
                              </div>
                              <div class="product-action-item">
								<button type="submit" class="dogri_cart_btn">
									<?php woocommerce_template_loop_add_to_cart(); ?>
								</button> 
								 <button type="submit" class="dogri_quick_view_btn">
								 	<?php $product_id = get_the_id();
            						echo do_shortcode("[woosq id='{$product_id}']");?>
								</button>
								<?php if (shortcode_exists('ti_wishlists_addtowishlist')) : ?>
								<button type="submit" class="dogri_wishlist_btn">
									<?php echo do_shortcode('[ti_wishlists_addtowishlist]');?>
								</button>
								<?php endif ?>
                              </div>
                              <div class="product-content">
                                 <div class="product-tag">
									<?php
									$tags = get_the_terms(get_the_ID(), 'product_tag');
									if ($tags && !is_wp_error($tags)) {
										foreach ($tags as $tag) {
											echo '<span><a href="' . get_term_link($tag) . '">' . $tag->name . '</a></span>';
										}									
									}
									?>
                                 </div>
                                 <h4 class="product-title"><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                                 <div class="product-price">
								 	<?php echo $product->get_price_html(); ?>
                                 </div>
                              </div>
                           </div>
                     	</div>
					 <?php endwhile; ?>
                  </div>
               </div>
               <div class="col-xxl-6 col-xl-6 col-lg-6">
                  <div class="product-banner">
                     <div class="product-banner-thumb" data-background="<?php echo wp_get_attachment_url($settings['bgimg']['id']);?>"></div>
                     <div class="product-banner-content text-center">
                        <div class="section-title-wrapper-4 is-white mb-20">
                           <span class="section-subtitle-4 mb-10"><?php echo $settings['subtitle'];?></span>
                           <h2 class="section-title-4"><?php echo $settings['subtitle'];?></h2>
                        </div>
                        <div class="tp-banner-btn">
                           <a href="<?php echo esc_url($settings['btnlink']['url']);?>" class="shop-link-btn"><?php echo $settings['bttn'];?>
                              <svg width="15" height="13" viewBox="0 0 15 13" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                 <path d="M13.9998 6.19656L1 6.19656" stroke="currentColor" stroke-width="1.5"
                                    stroke-linecap="round" stroke-linejoin="round"></path>
                                 <path d="M8.75674 0.975394L14 6.19613L8.75674 11.4177" stroke="currentColor"
                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                              </svg>
                           </a>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- Best seller area end -->

	<?php endif ;?>	



        <?php
    }
}
